<?php
if ( function_exists( "wfLoadExtension" ) ) { // MediaWiki >= 1.25
  wfLoadExtension( "scoutnet_kalender" );
  // Keep i18n globals so mergeMessageFileList.php doesn't break
  #  $wgMessagesDirs["scoutnet_kalender"] = __DIR__ . '/i18n';
  #  $wgExtensionMessagesFiles["scoutnet_kalenderAlias"] = __DIR__ . '/scoutnet_kalender.alias.php';
  wfWarn(
    "Es wird ein veralteter PHP-Aufruf für die Scoutnet-Kalender Erweiterung verwendet. " .
    "Verwende bitte stattdessen <code>wfLoadExtension</code> zum Einbinden in localsettings.php, " .
    "siehe https://www.mediawiki.org/wiki/Extension_registration für weitere Details."
  );
  return;
} else { // MediaWiki < 1.25

    $wgExtensionCredits["validextensionclass"][] = array(
      "path"         => __FILE__,
      "name"         => "Scoutnet Kalender",
      "author"       => array("Mütze", "Micha"),
      "url"          => "http://www.scoutnet.de/kalender/include/einbindung-cms.html#mediawiki",
      "description"  => "Einbindung des Scoutnet-Kalenders einer Gruppe in ein MediaWiki",
      "version"      => 1.0,
      "license-name" => "GPL-2.0+",
    );

    require_once("includes/jsonRPCClient.php"); // JSON RPC-Client einbinden
    include("scoutnet_kalender.class.php");

    // Setup Funktion definieren
    $wgExtensionFunctions[]         = "ScoutnetKalenderClass::SNKParserFunction_Setup";
    // Hook hinzufügen um Magische Worte zu initialisieren
    $wgHooks["LanguageGetMagic"][]  = "ScoutnetKalenderClass::SNKParserFunction_Magic";
    $wgHooks["BeforePageDisplay"][] = "ScoutnetKalenderClass::SNKParserFunction_Head";
}
?>