<?php
 
require_once('jsonRPCClient.php');

# Define a setup function
$wgExtensionFunctions[] = 'SNKParserFunction_Setup';
# Add a hook to initialise the magic word
$wgHooks['LanguageGetMagic'][]       = 'SNKParserFunction_Magic';
$wgHooks['BeforePageDisplay'][] = 'SNKParserFunction_Head';
 
function SNKParserFunction_Setup() {
        global $wgParser;
        $wgParser->setFunctionHook( 'snk', 'SNKParserFunction_Render' );
        $wgParser->setFunctionHook( 'snk_openInfo', 'SNKParserFunction_OpenInfo' );
        $wgParser->setFunctionHook( 'snk_addSSIDForm', 'SNKParserFunction_addSSIDForm' );

}

function SNKParserFunction_Head( &$out, &$sk){
	$out->addScript('<script type="text/javascript" src="/extensions/scoutnet_kalender/behavior.js"</script>');
	$out->addScript('<script type="text/javascript" src="http://kalender.scoutnet.de/js/base2-p.js"></script>');
	$out->addScript('<script type="text/javascript" src="http://kalender.scoutnet.de/js/base2-dom-p.js"></script>');
	$out->addInlineScript("base2.DOM.bind(document); snk_init(); document.addEventListener('DOMContentLoaded', function(){ return snk_finish('http://kalender.scoutnet.de/2.0/show.php?id=17'); }, false);"); 

	return true;

}
 
function SNKParserFunction_Magic( &$magicWords, $langCode ) {
        # Add the magic word
        # The first array element is case sensitive, in this case it is not case sensitive
        # All remaining elements are synonyms for our parser function
        $magicWords['snk'] = array( 0, 'snk' );
        $magicWords['snk_openInfo'] = array( 0, 'snk_openInfo' );
        $magicWords['snk_addSSIDForm'] = array( 0, 'snk_addSSIDForm' );
        # unless we return true, other parser functions extensions won't get loaded.
        return true;
}
 
function SNKParserFunction_OpenInfo( &$parser, $id = '17' ,$value = '') {
	$text = '<a href="#snk-termin-'.$id.'" class="snk-termin-link" onclick="if(snk_show_termin) return snk_show_termin('.$id.',this); ">'.$value.'</a>';
        return array($text,'isHTML'=>true);
}

function SNKParserFunction_addSSIDForm( &$parser, $ssids = '') {
	$text = 'Zeige auch diese Kalender an: <br><form action="#" method="get">';
	
	$SN = new jsonRPCClient("http://www.scoutnet.de/jsonrpc/server.php");

	$res = $SN->get_data_by_global_id(split(",",$ssids),array('kalenders'=>array()));

	foreach ($res as $record) {
		if ($record['type'] == 'kalender'){
			$kalender = $record['content'];

			$ssid = $kalender['ID'];

			$text .= '<input onchange="form.submit();" type="checkbox" id="kalender_'.$ssid.'" name="addIds['.$ssid.']" value="'.$ssid.'"'.($_GET['addIds'][$ssid] == $ssid?' checked ':'').'/>&nbsp;<label for="kalender_'.$ssid.'">'.$kalender['Ident'].'</label>&nbsp;';
		}
	}


	$text .= '</form>';
        return array($text,'isHTML'=>true);
}

function SNKParserFunction_Render( &$parser, $ssid = '17', $limit = 50, $addssid = '' ) {

	$parser->disableCache();

	if (!is_numeric($limit)) {
		$limit = 50;
	}

	$current_month = "";
	$kalenderArray = Array();
	$stufenArray = Array();

	$ssids = split(",",$ssid);

	if (isset($_GET['addIds'])){
		foreach ($_GET['addIds'] as $addid) {
			if (is_numeric($addid)){
				$ssids[] = $addid;
			}
		}
	}


	$filter = array('events'=>array('limit'=>$limit,'after'=>'now()'));

	$SN = new jsonRPCClient("http://www.scoutnet.de/jsonrpc/server.php");

	$res = $SN->get_data_by_global_id($ssids,$filter);

	$text = "";


	if ($addssid) {
		$text .= "{{ #snk_addSSIDForm: $addssid}}\n";
	
	}

	$text .= "{| class=\"wikitable\"\n";
	foreach ($res as $record) {
		if ($record['type'] === 'event') {
			$line = $record['content'];


			if ($current_month != gmstrftime("%B '%y",$line['Start'])) {
				$text .= "|-\n";
				$text .= "! colspan=\"5\" |'''".gmstrftime("%B '%y",$line['Start'])."''':\n";
				$text .= "|-\n";

				$current_month = gmstrftime("%B '%y",$line['Start']);
			}


			$text .= "{{snk_termin";
			foreach ($line as $key=>$value) {
				$text .= "|".strtolower($key)." = ";
				switch ($key) {
					case "ID":
					case "UID":
					case "SSID":
					case "Organizer":
					case "Target_Group":
					case "All_Day":
					case "ZIP":
					case "Location":
					case "URL_Text":
					case "URL":
					case "Description":
					case "Last_Modified_By":
					case "Created_By":
						$text .= $value;
						break;
					case "Title":
						if ($line['Description'].$line['ZIP'].$line['Location'].$line['Organizer'].$line['Target_Group'].$line['URL_Text'].$line['URL']) {
							$text .= "{{ #snk_openInfo: ".$line['ID']."|$value}}";
						} else {
							$text .= $value;
						}
						break;
					case "Stufen":
						if (!is_array($value)) {
							$value= array($value);
						}

						foreach ($value as $st_key=>$st_val) {
							$text .= "{{snk_stufe";
							foreach ($stufenArray[$st_val] as $kal_key=>$kal_value){
								$text .= "|".strtolower($kal_key)."=".$kal_value;
							}
							$text .= "}}";
						}
						break;
					case "Keywords":
						if (!is_array($value)) {
							$value= array($value);
						}

						$first = true;
						foreach ($value as $st_key=>$st_val) {
							if (!$first) {
								$text .= ", ";
							}
							$first = false;
							$text .= "{{snk_keyword";
							$text .= "|id=$st_key|value=$st_val";
							$text .= "}}";
						}
						break;
					case "Start":
					case "End":
						$text .= gmstrftime("%a, %d.%m",$value).($line['All_Day']?"":" ".gmstrftime("%H:%M",$value)."&nbsp;Uhr");
						break;
					case "Kalender":
						$text .= "{{snk_kalender";
						foreach ($kalenderArray[$value] as $kal_key=>$kal_value){
							$text .= "|".strtolower($kal_key)."=".$kal_value;
						}
						$text .= "}}";
						break;
					default:
					break;	
				}
			}

			$text .= "|zeit = ".gmstrftime("%a, %d.%m",$line['Start']).($line['All_Day']?"":" ".gmstrftime("%H:%M",$line['Start'])."&nbsp;Uhr");
			if ($line['Start'] != $line['End']) {
				$text .= " - ".(gmstrftime("%d.%m",$line['Start']) == gmstrftime("%d.%m",$line['End'])?"":gmstrftime("%a, %d.%m",$line['End'])).($line['All_Day']?"":" ".gmstrftime("%H:%M",$line['End'])."&nbsp;Uhr");
			}
			$text .= "}}\n";

		} else if ($record['type'] == 'kalender') {
			$kalenderArray[$record['content']['ID']] = $record['content'];
		} else if ($record['type'] == 'stufe') {
			$stufenArray[$record['content']['Keywords_ID']] = $record['content'];
		}

		$text .= "|-\n";
	}
	$text .= "|}";

        return array($text,'noparse'=>false);
}
