# -*- coding: utf-8 -*-
import urllib,urllib2
try:
    import json
except:
    import simplejson as json
    
def scoutnet():
    return API()
    
class Kind(object):
    def __init__( self, data , api):
        self.data = data
        self.api  = api
    def __getattr__( self, name ):
        return self.data[name]
    def __repr__(self):
        return str(type(self).__name__)+'('+repr(self.data)+","+repr(self.api)+')'


class Event(Kind):
    pass


class Group(Kind):
    def events(self,query="",args=[]):
        return self.api.events(("group_id == %s" % self.global_id)+((query and (' AND '+query)) or ''),args)


class API(object):
    _base_url = 'http://localhost/snk/www.scoutnet.de/public_html/api/0.1/'
    _base_url = 'http://www.scoutnet.de/api/0.1/'
    
    def _query( self, kind, query, args = [] ):
        url = self._base_url+kind+'s/?json='+urllib.quote(json.dumps([query,args]))
        return self._fetch(url)['elements'].values()

    def _fetch( self, url ):
        try:
            data = urllib2.urlopen(url).read()
            #print data
            return json.loads(data)
        except:
            print 'ERROR ON:'
            print url
            print data
            raise

    def _fetch_many( self, kind, ids ):
        url = self._base_url+kind+'s/?json='+urllib.quote(json.dumps([ids]))
        return self._fetch(url)['elements'].values()

    def _fetch_one( self, kind, id ):
        url = self._base_url+kind+'/'+str(id)+'/'
        return self._fetch(url)

    def event( self, id ):
        return Event( self._fetch_one('event',id), self )
    
    def group( self, id ):
        return Group( self._fetch_one('group',id), self )
    
    def _many( self, kind, ids_or_query, args = [] ):
        if( isinstance(ids_or_query,basestring) ):
            return self._query(kind,ids_or_query,args)
        elif( isinstance(ids_or_query,list) ):
            return self._fetch_many(kind,ids_or_query)
        raise Exception( 'expected non-empty string or iterable' )
    def events( self, ids_or_query, args=[] ):
        return map( (lambda e:Event(e,self)), self._many( 'event', ids_or_query, args ) )

    def groups( self, ids_or_query, args=[] ):
        return map( (lambda e:Group(e,self)), self._many( 'group', ids_or_query, args ) )
    
    def __repr__(self):
      return "API()"

if __name__ == '__main__':
    for i in scoutnet().groups([4,5,6]):
        print i.name
